/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cecdiscover.server;

import com.ibm.hsc.cecdiscover.server.HSCDiscoverFileHandler;
import com.ibm.hsc.common.util.CommandMonitor;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class HSCCECDiscoveryMgr
extends Thread {
    public static final String FSP_VALIDATOR = "/opt/hsc/bin/isSP ";
    public static final String HMC_PROPERTIES = "/opt/hsc/data/hmc.properties";
    public static final String IGNORE_PASSWORD = " --ignorepasswd";
    public static final String IP_PARAM = "--ip ";
    public static final String MKSYSCONN = "/opt/hsc/bin/command/mksysconn ";
    public static HSCCECDiscoveryMgr mInstance = null;
    private HSCDiscoverFileHandler discoverHandler = new HSCDiscoverFileHandler();

    private HSCCECDiscoveryMgr() {
        try {
            this.discoverHandler.init();
            this.debug("Starting Discovery...");
            this.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
        }
    }

    public static synchronized HSCCECDiscoveryMgr getInstance() {
        if (null == mInstance) {
            mInstance = new HSCCECDiscoveryMgr();
        }
        return mInstance;
    }

    public void run() {
        boolean bl = false;
        long l = 60000L;
        FileInputStream fileInputStream = null;
        Properties properties = null;
        String string = null;
        Vector<String> vector = null;
        Vector<String> vector2 = null;
        Vector vector3 = null;
        try {
            fileInputStream = new FileInputStream(HMC_PROPERTIES);
            properties = new Properties();
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = properties.getProperty("CecDiscoverServerSleepDurationInSec");
        if (string2 != null) {
            l = new Long(string2) * 1000L;
        }
        while (true) {
            vector = new Vector<String>();
            vector2 = new Vector<String>();
            try {
                int n;
                vector3 = this.discoverHandler.getIPsAdded();
                if (null != vector3 && vector3.size() > 0) {
                    this.debug("new ips found");
                    for (n = 0; n < vector3.size(); ++n) {
                        string = (String)vector3.get(n);
                        this.debug("Check the IP for type");
                        if (this.discoverHandler.isRemovedIP(string) || this.discoverHandler.isConfiguredIP(string)) continue;
                        int n2 = this.isFSP(string);
                        if (n2 == 0) {
                            this.debug("New IP " + string + " (FSP) has been added");
                            vector.add(string);
                            continue;
                        }
                        if (n2 != 1) continue;
                        this.debug("New IP " + string + " (BPC) has been added");
                        vector2.add(string);
                    }
                }
                if (null != vector && vector.size() > 0) {
                    for (n = 0; n < vector.size(); ++n) {
                        string = (String)vector.get(n);
                        this.addIPToHdwrSvr(string);
                        bl = true;
                    }
                }
                if (null != vector2 && vector2.size() > 0) {
                    for (n = 0; n < vector2.size(); ++n) {
                        string = (String)vector2.get(n);
                        this.addBPAToHdwrSvr(string);
                        bl = true;
                    }
                }
                if (!bl) {
                    try {
                        HSCCECDiscoveryMgr.sleep(l);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                bl = false;
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
                HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
                continue;
            }
            break;
        }
    }

    private void debug(String string) {
        System.out.println("DIS." + string);
    }

    private int isFSP(String string) throws Throwable {
        String string2 = new String(FSP_VALIDATOR + string);
        this.debug("cmd is " + string2);
        boolean bl = false;
        int n = 0;
        int n2 = -1;
        CommandMonitor commandMonitor = new CommandMonitor();
        n = commandMonitor.exec(string2, OmConsoleMgr.CecDiscoverCommandTimeoutInSec * 1000);
        Process process = commandMonitor.getProcess();
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = null;
            String string4 = null;
            try {
                String string5;
                stringTokenizer = new StringTokenizer(string3);
                string4 = stringTokenizer.nextToken();
                if (!string4.equals("System") || !stringTokenizer.hasMoreTokens() || !(string5 = stringTokenizer.nextToken()).equals("info:")) continue;
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                String string6 = stringTokenizer.nextToken();
                this.debug("mtms read in = " + string6);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.debug("Line not tokenizable, continuing...");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        bufferedReader.close();
        if (0 == n) {
            if (n2 == 2) {
                this.debug("IP " + string + " is a CEC FSP");
                return 0;
            }
            if (n2 == 1) {
                this.debug("IP " + string + " is a BPC FSP");
                return 1;
            }
            this.debug("Error in isSP stdOut parsing, not a fsp/bpc type, ret_value=" + n2);
            return -1;
        }
        return -1;
    }

    private void addIPToHdwrSvr(String string) throws Throwable {
        String string2 = null;
        OmConsoleMgr.getConsoleMgr().addSys(string, string2, 0);
    }

    private void addBPAToHdwrSvr(String string) throws Throwable {
        String string2 = null;
        OmConsoleMgr.getConsoleMgr().addSys(string, string2, 1);
    }

    private boolean isDhcpIp(String string) {
        try {
            Vector vector = this.discoverHandler.getIPsAdded();
            if (vector == null || vector.size() < 1) {
                return false;
            }
            for (int i = 0; i < vector.size(); ++i) {
                if (!string.equals((String)vector.elementAt(i))) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIp(String string) {
        Object object;
        System.out.println("Entering addToRemoveFile...");
        System.out.println("looking up cec mgr with ip = " + string);
        String string2 = "-";
        String string3 = "-";
        if (string != null) {
            try {
                object = InetAddress.getByName(string);
                string2 = ((InetAddress)object).getHostName();
                string3 = ((InetAddress)object).getHostAddress();
                System.out.println("(converted) hostName = " + string2 + " ipAddr = " + string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (!this.isDhcpIp(string3)) {
            return;
        }
        object = null;
        try {
            object = new RandomAccessFile("/opt/hsc/data/.hmc/.removed", "rw");
            ((RandomAccessFile)object).seek(((RandomAccessFile)object).length());
            String string4 = string3 + " " + string2 + "\n";
            System.out.println("writing following line to rm file:  >" + string4 + "<");
            ((RandomAccessFile)object).writeBytes(string4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                ((RandomAccessFile)object).close();
            }
            catch (Throwable throwable) {}
        }
        System.out.println("Exiting addToRemoveFile...");
    }

    public static final void main(String[] stringArray) {
        HSCCECDiscoveryMgr hSCCECDiscoveryMgr = HSCCECDiscoveryMgr.getInstance();
    }
}

